PACKAGE instr IS
  TYPE instruction IS ( add, sub, lda, ldb, sta, stb, outa, xfr );
END instr;

USE WORK.instr.ALL;
ENTITY mp IS
  PORT (instr : IN instruction;
        addr  : IN INTEGER;
        data  : INOUT INTEGER);
END mp;

ARCHITECTURE mp OF mp IS
BEGIN
  PROCESS(instr)
    TYPE regtype IS ARRAY(0 TO 255) OF INTEGER;
    VARIABLE a, b : INTEGER;
    VARIABLE reg : regtype;
  BEGIN
                     -- select instruction to
    CASE instr is    -- execute
      WHEN lda =>
        a := data;  -- load a accumulator

      WHEN ldb =>
        b := data;  -- load b accumulator

      WHEN add =>
        a := a + b; -- add accumulators

      WHEN sub =>
        a := a - b; -- subtract accumulators

      WHEN sta =>
        reg(addr) := a; -- put a accum in reg array 

      WHEN stb =>
        reg(addr) := b; -- put b accum in reg array

      WHEN outa =>
        data <= a;      -- output a accum
     
      WHEN xfr =>         -- transfer b to a
        a := b;

    END CASE;
  END PROCESS;
END mp;              


